<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\Block;

trait TraitUserBlockSetters
{
    use TraitUserBlockProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setBlockedUserId(string $blockedUserId)
    {
        $this -> blockedUserId = $blockedUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setBlockedByUserId(string $blockedByUserId)
    {
        $this -> blockedByUserId = $blockedByUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
